require 'sketchup.rb'

#version 0.1


if( not file_loaded?("polyreduce.rb") )

   UI.add_context_menu_handler { |menu|
            selection=Sketchup.active_model.selection
			if(!selection.empty?)
                sub_menu=menu.add_item("Polyreduce") {Polyreduce.new.reduce_polygons()}
            end
        }
#tools_menu = UI.menu("Tools")
#tools_menu.add_separator
#main_menu=tools_menu.add_item("Polyreducer") {(Polyreduce.new.reduce_polygons())}
#main_menu=tools_menu.add_item("Collapse Edge") {(Polyreduce.new.collapse_edge(Sketchup.active_model.selection.first))}


end

file_loaded("polyreduce.rb")


class Polyreduce


#method to triangulate existing faces  (ents is an Sketchup::Entities object, mesh is an array of entities)
def triangulate(ents,mesh)


mesh.each {|ent|

if ent.class==Sketchup::Face
	if ent.vertices.length>3
		f_mat=ent.material
		b_mat=ent.back_material
		polymesh=ent.mesh
		ents.erase_entities(ent)
		polys=polymesh.polygons
		polys.each {|poly|
			begin
				new_face=ents.add_face(polymesh.point_at(poly[0]),polymesh.point_at(poly[1]),polymesh.point_at(poly[2]))
				new_face.material=f_mat
				new_face.back_material=b_mat
			rescue
				p polymesh.point_at(poly[0]),polymesh.point_at(poly[1]),polymesh.point_at(poly[2])
				#raise
			end
		}
	end
end

}

end

#############################

			
def compute_edge_costs(mesh)

s=Time.new

all_verts=[]
$polyreduce_collapse=Hash.new
$polyreduce_cost=Hash.new
$polyreduce_all_verts=[]

mesh.each {|ent|
	#collect all the vertices in the mesh
	if ent.class==Sketchup::Face
		edges=ent.edges
		for edge in edges
			unless edge.faces.length==1  #this is a free edge so don't add the vertices
				all_verts.push(edge.vertices)
			end
		end
	end
}

#remove redudant vertices
all_verts.flatten!
all_verts.uniq!
$polyreduce_all_verts=all_verts

all_verts.each {|v| compute_edge_cost_at_vertex(v)}

#p "computed edge costs in #{Time.new-s} seconds"


end

##################################################

def reduce(mesh,percentage)


#triangulate(Sketchup.active_model.active_entities,mesh)
triangulate(Sketchup.active_model.active_entities,Sketchup.active_model.selection.first.all_connected)

compute_edge_costs(mesh)

num_verts=$polyreduce_cost.length
new_num_verts=(percentage*num_verts.to_f).to_i
collapsed=0

#p $polyreduce_cost.length
#p new_num_verts

while $polyreduce_cost.length>new_num_verts
	#p $polyreduce_cost.length
	vert=get_minimum_cost_edge()
	collapse(vert,$polyreduce_collapse[vert])
	collapsed+=1
	Sketchup.set_status_text("Collapsed #{collapsed} of #{num_verts-new_num_verts} edges")
end

end

##################################################
def get_minimum_cost_edge()

s=Time.new

min_cost=100000000.0
$polyreduce_cost.each_value {|cost|
	min_cost=[min_cost,cost].min
}

return $polyreduce_cost.index(min_cost)

end


###################################################

def collapse_edge(edge)

Sketchup.active_model.start_operation("Collapse")
collapse(edge.start,edge.end)
Sketchup.active_model.commit_operation

end


######################################
def compute_edge_collapse_cost(u,v)

#u=edge.start
#v=edge.end

# if we collapse edge uv by moving u to v then how
#much different will the model change, i.e. the error.

edgelength=(v.position-u.position).length
curvature=0

#find the sides triangles that are on the edge uv
edge=u.common_edge(v)
sides=edge.faces

#use the triangle facing most away from the sides
# to determine our curvature term
u_faces=u.faces
u_faces.each {|face|
	mincurv=1.0
	sides.each {|side|
	#use dot product of face normals.
	dotprod=(face.normal)%(side.normal)
	mincurv=[mincurv,((1.0-dotprod)/2.0)].min
	}
curvature=[curvature,mincurv].max
}
return edgelength*curvature

end

#######################################
def compute_edge_cost_at_vertex(vert)

#get all the neighboring vertices of this vertex
return if vert.deleted?
neighbors=get_neighbors(vert)

if neighbors.length==0
	$polyreduce_collapse[vert]=nil  #the candidate vertex for the collapse
	$polyreduce_cost[vert]=-0.01
	return
end

$polyreduce_cost[vert]=1000000.0
$polyreduce_collapse[vert]=nil

#search all neighboring edges for least cost edge

neighbors.each {|n|
	cost=compute_edge_collapse_cost(vert,n)
	
	if cost<$polyreduce_cost[vert]
		$polyreduce_collapse[vert]=n
		$polyreduce_cost[vert]=cost
	end
}

end


########################################
def collapse(u,v)

return if u.deleted?
ents=Sketchup.active_model.active_entities
u_faces=u.faces

#Collapse the edge uv by moving vertex u onto v
if not v
	#u is a vertex all by itself so just delete it
	ents.erase_entities(u)
	return
end

#create a temporary list of all the neighbors of vertex u
tmp=get_neighbors(u)

#delete triangles on edge uv
common_edge=u.common_edge(v)
edge_faces=common_edge.faces

#remove the edge faces from the array of faces connected to vertex u
edge_faces.each {|f| u_faces.delete(f)}
edge_faces.each {|f| ents.erase_entities(f) if not f.deleted? }
ents.erase_entities(common_edge) if not common_edge.deleted?


#update remaining triangles to have v instead of u

u_faces.each {|f|
	#p "replacing vertex"
	replace_vertex(ents,f,u,v)
}

#delete the old vertex from the hash
$polyreduce_collapse.delete(u)
$polyreduce_cost.delete(u)

ents.erase_entities(u.edges) if not u.deleted?

#recompute the edge collapse costs in neighborhood
tmp.each {|v|
	compute_edge_cost_at_vertex(v)
}

end

###############################################
def replace_vertex(ents,face,old_vert,new_vert)

s=Time.new

#face has three verts and three edges
verts=face.vertices
points=[]
verts.each {|v| points.push(v.position)}

#get the index of the original vertex
old_index=verts.index(old_vert)

#replace the original point with the new point
points[old_index]=new_vert.position

verts=face.vertices
verts.each {|v|
	$polyreduce_collapse.delete(v)
	$polyreduce_cost.delete(v)
}

mat=face.material
b_mat=face.back_material
	
ents.erase_entities(face)
begin
	new_face=ents.add_face(points)
	new_face.material=mat
	new_face.back_material=b_mat
rescue
	p points
	raise
end


end

###############################################
def replace_vertex_test(ents,old_vert,new_vert)

vector=new_vert.position-old_vert.position
trans=Geom::Transformation.translation(vector)
ents.transform_entities(trans,[old_vert])

$polyreduce_collapse.delete(old_vert)
$polyreduce_cost.delete(old_vert)


end

###################################
def get_neighbors(vert)

edges=vert.edges
neighbors=[]
edges.each{|edge|
	s=edge.start
	e=edge.end
	neighbors.push(s) if s!=vert
	neighbors.push(e) if e!=vert
}
#remove any redundant vertices
neighbors.uniq!

#remove the vertex if this vertex was not in the original selection of vertices
neighbors.delete_if {|x| $polyreduce_all_verts.index(x)==nil}
return neighbors

end

#######################################
def reduce_polygons()

#$get_min_edge_time=Time.new-Time.new
#$get_replace_vert_time=Time.new-Time.new
Sketchup.active_model.start_operation("Reduce Polygons")
ents=Sketchup.active_model.active_entities
sel=Sketchup.active_model.selection
if sel.count==0
	UI.messagebox "You must make a selection first."
	return false
end

prompts=["Percent Reduction"]
values=[50]
enums=[["10|20|30|40|50|60|70|80|90"]]
results=UI.inputbox(prompts,values,enums,"Reduce Polygons")
return if not results

reduce(sel,1.0-(results[0].to_f/100))

Sketchup.active_model.commit_operation

#p "found minimum cost edge took #{$get_min_edge_time} seconds."
#p "replacement of vertices took #{$get_replace_vert_time} seconds."

end



end #end class



